/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.rendering;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.mapgen.model.AbstractGameMap;
import technology.rocketjump.undermount.mapgen.model.FloorType;
import technology.rocketjump.undermount.mapgen.model.HeightGameMap;
import technology.rocketjump.undermount.mapgen.model.RockGroup;
import technology.rocketjump.undermount.mapgen.model.VertexGameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.TileSubType;

public class MapRenderer {
    private static final Color TREE_BARK_COLOR = new Color(0.4f, 0.2f, 0.0f, 1.0f);
    private static final Color TREE_LEAF_COLOR = new Color(0.3647059f, 0.8352941f, 0.3647059f, 1.0f);
    private static final Color SHRUB_COLOR = new Color(0.35686275f, 0.7019608f, 0.24313726f, 1.0f);
    private ShapeRenderer shapeRenderer;
    private OrthographicCamera camera = new OrthographicCamera();

    public MapRenderer() {
        this.shapeRenderer = new ShapeRenderer();
    }

    public <T extends AbstractGameMap> void render(T map) {
        if (map instanceof VertexGameMap) {
            this.renderVertexMap((VertexGameMap)map);
        } else if (map instanceof HeightGameMap) {
            this.renderHeightMap((HeightGameMap)map);
        } else if (map instanceof GameMap) {
            this.renderGameMap((GameMap)map);
        }
    }

    public void renderGameMap(GameMap gameMap) {
        float heightScaling;
        int screenWidth = Gdx.graphics.getWidth();
        int screenHeight = Gdx.graphics.getHeight();
        this.camera.setToOrtho(false, screenWidth, screenHeight);
        int mapWidth = gameMap.getWidth();
        int mapHeight = gameMap.getHeight();
        float widthScaling = (float)screenWidth / (float)mapWidth;
        float tileSize = heightScaling = (float)screenHeight / (float)mapHeight;
        if (heightScaling * (float)mapWidth > (float)screenWidth) {
            tileSize = widthScaling;
        }
        float mapWidthPixels = tileSize * (float)mapWidth;
        float mapHeightPixels = tileSize * (float)mapHeight;
        float originX = (float)(screenWidth / 2) - mapWidthPixels / 2.0f;
        float originY = (float)(screenHeight / 2) - mapHeightPixels / 2.0f;
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
        for (int y = mapHeight - 1; y >= 0; --y) {
            for (int x = 0; x < mapWidth; ++x) {
                GameMapTile tile = gameMap.get(x, y);
                if (tile.hasTree()) {
                    this.shapeRenderer.setColor(TREE_BARK_COLOR);
                    this.shapeRenderer.rect(originX + (float)x * tileSize, originY + (float)y * tileSize, tileSize, tileSize * 4.0f);
                    this.shapeRenderer.setColor(TREE_LEAF_COLOR);
                    this.shapeRenderer.circle(originX + (float)x * tileSize + tileSize / 2.0f, originY + (float)y * tileSize + tileSize * 3.5f, tileSize * 1.5f);
                    continue;
                }
                if (tile.hasShrub()) {
                    this.shapeRenderer.setColor(SHRUB_COLOR);
                    if (tile.getShrubType().hasFruit()) {
                        this.shapeRenderer.setColor(SHRUB_COLOR.cpy().add(0.1f, 0.1f, 0.1f, 0.0f));
                    }
                    this.shapeRenderer.circle(originX + (float)x * tileSize + tileSize / 2.0f, originY + (float)y * tileSize + tileSize / 2.0f, tileSize * 0.5f);
                    continue;
                }
                this.shapeRenderer.setColor(this.toColor(tile, gameMap));
                this.shapeRenderer.rect(originX + (float)x * tileSize, originY + (float)y * tileSize, tileSize, tileSize);
            }
        }
        this.shapeRenderer.end();
    }

    public void renderHeightMap(HeightGameMap heightMap) {
        float heightScaling;
        int screenWidth = Gdx.graphics.getWidth();
        int screenHeight = Gdx.graphics.getHeight();
        this.camera.setToOrtho(false, screenWidth, screenHeight);
        int mapWidth = heightMap.getWidth();
        int mapHeight = heightMap.getHeight();
        float widthScaling = (float)screenWidth / (float)mapWidth;
        float tileSize = heightScaling = (float)screenHeight / (float)mapHeight;
        if (heightScaling * (float)mapWidth > (float)screenWidth) {
            tileSize = widthScaling;
        }
        float mapWidthPixels = tileSize * (float)mapWidth;
        float mapHeightPixels = tileSize * (float)mapHeight;
        float originX = (float)(screenWidth / 2) - mapWidthPixels / 2.0f;
        float originY = (float)(screenHeight / 2) - mapHeightPixels / 2.0f;
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
        for (int y = mapHeight - 1; y >= 0; --y) {
            for (int x = 0; x < mapWidth; ++x) {
                float heightmapValue = heightMap.getHeight(x, y);
                this.shapeRenderer.setColor(this.toColor(heightmapValue));
                this.shapeRenderer.rect(originX + (float)x * tileSize, originY + (float)y * tileSize, tileSize, tileSize);
            }
        }
        this.shapeRenderer.end();
    }

    public void renderVertexMap(VertexGameMap vertexMap) {
        float heightScaling;
        int screenWidth = Gdx.graphics.getWidth();
        int screenHeight = Gdx.graphics.getHeight();
        this.camera.setToOrtho(false, screenWidth, screenHeight);
        int mapWidth = vertexMap.getNumTilesWide();
        int mapHeight = vertexMap.getNumTilesHigh();
        float widthScaling = (float)screenWidth / (float)mapWidth;
        float tileSize = heightScaling = (float)screenHeight / (float)mapHeight;
        if (heightScaling * (float)mapWidth > (float)screenWidth) {
            tileSize = widthScaling;
        }
        float originX = (float)(screenWidth / 2) - tileSize * (float)mapWidth / 2.0f;
        float originY = (float)(screenHeight / 2) - tileSize * (float)mapHeight / 2.0f;
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
        for (int y = mapHeight - 1; y >= 0; --y) {
            for (int x = 0; x < mapWidth; ++x) {
                float heightmapX0Y0 = vertexMap.get(x, y).getHeight();
                float heightmapX1Y0 = vertexMap.get(x + 1, y).getHeight();
                float heightmapX0Y1 = vertexMap.get(x, y + 1).getHeight();
                float heightmapX1Y1 = vertexMap.get(x + 1, y + 1).getHeight();
                float averageHeight = (heightmapX0Y0 + heightmapX0Y1 + heightmapX1Y0 + heightmapX1Y1) / 4.0f;
                Vector2 lowerLeftPoint = new Vector2(originX + (float)x * tileSize, originY + (float)y * tileSize);
                this.shapeRenderer.setColor(this.toColor(averageHeight));
                this.shapeRenderer.rect(lowerLeftPoint.x, lowerLeftPoint.y, tileSize, tileSize);
            }
        }
        this.shapeRenderer.end();
    }

    private Color toColor(GameMapTile tile, GameMap gameMap) {
        if (tile.hasRiver()) {
            if (gameMap.getRiverStartTiles().contains(tile.getPosition())) {
                return Color.BLUE.cpy().add(0.2f, 0.2f, 0.0f, 1.0f);
            }
            if (gameMap.getRiverEndTiles().contains(tile.getPosition())) {
                return Color.BLUE.cpy().mul(0.7f);
            }
            return Color.BLUE;
        }
        if (tile.getFloorType() == FloorType.Outdoor) {
            return this.toBiomeColor(tile);
        }
        if (tile.getFloorType() == FloorType.Rock) {
            if (tile.getRockType() != null) {
                return tile.getRockType().getColor().cpy().mul(0.5f);
            }
            if (!tile.getRockGroup().equals((Object)RockGroup.None)) {
                return tile.getRockGroup().getColor().cpy().mul(0.5f);
            }
            return Color.GRAY;
        }
        if (tile.getGem() != null) {
            return tile.getGem().getColor();
        }
        if (tile.hasOre()) {
            return tile.getOre().getOreColor();
        }
        if (tile.getRockType() != null) {
            return tile.getRockType().getColor();
        }
        if (!tile.getRockGroup().equals((Object)RockGroup.None)) {
            return tile.getRockGroup().getColor();
        }
        return Color.LIGHT_GRAY;
    }

    private Color toBiomeColor(GameMapTile tile) {
        if (tile.getTileSubType() == null) {
            return this.toColor(tile.getNoisyHeightValue());
        }
        if (tile.getTileSubType().equals((Object)TileSubType.FOREST)) {
            return new Color(0.18431373f, 0.5568628f, 0.18431373f, 1.0f);
        }
        if (tile.getTileSubType().equals((Object)TileSubType.GRASSLAND)) {
            return new Color(0.16470589f, 0.63529414f, 0.16470589f, 1.0f);
        }
        if (tile.getTileSubType().equals((Object)TileSubType.PLAINS)) {
            return new Color(0.20392157f, 0.79607844f, 0.20392157f, 1.0f);
        }
        return new Color(0.3647059f, 0.8352941f, 0.3647059f, 1.0f);
    }

    private Color toColor(float height) {
        return new Color(height, height, height, 1.0f);
    }
}

